<?php $__env->startSection('title', __('Module managers')); ?>
<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
	<h1 class="h3 mb-0 text-gray-800"><?php echo app('translator')->get('Modules manager'); ?></h1>
</div>
<div class="row">
	<div class="col-md-3">
		<?php echo $__env->make('core::partials.settings-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	</div>
	<div class="col-md-9">
		<?php if($data['products'] && count($data) > 0): ?>
		<div class="row row_blog_responsive pt-4 clearfix">
			<?php $__currentLoopData = $data['products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<?php
				$check = check_product_purchase($item['pd_pid']);
				$product_version = get_latest_version_product_id($item['pd_pid']);
			?>
			<div class="col-xl-5 col-lg-6 col-md-4 col-sm-6 col-12 itembb">
				<div class="clearfix blog-bottom blog blogitemlarge">
					
					<div class="content_blog clearfixflex flex-column flex-lg-row">
						<p title="<?php echo e($item['pd_name']); ?>" class="min-h-100 p-2">
							<?php echo e($item['pd_details']); ?>

						</p>
						<div class="p-2">
							<h6 class="font-weight-bold text-secondary text-uppercase mb-1"><?php echo e($item['pd_name']); ?></h6>
						</div>
						<?php if($check): ?>
							<?php if($product_version && $product_version['latest_version'] != $check->version): ?>
							<span class="p-2 text-warning"><?php echo app('translator')->get('Version :version is available. Update now',['version' => $product_version['latest_version']]); ?></span>
							<?php endif; ?>
							<div class="d-flex p-2">
								<button href="#" class="btn btn-sm btn-success mr-2" disabled><i class="fas fa-check-circle"></i> <?php echo app('translator')->get('Installed'); ?></button>	
								<?php if($product_version && $product_version['latest_version'] != $check->version): ?>
									<form method="post" id="formUpdateVersion" action="<?php echo e(route('settings.modulesmanager.update', $item['pd_pid'])); ?>" >
				                      <?php echo csrf_field(); ?>
				                      <button type="submit" id="btnUpdateVersion" class="btn btn-sm btn-danger">
				                      	<i class="fas fa-download"></i> <?php echo app('translator')->get("Update"); ?> <?php echo e($product_version['latest_version']); ?>

				                      </button>
				                    </form>
								<?php else: ?>
									<button href="#" class="btn btn-sm btn-primary" disabled><?php echo app('translator')->get('Version'); ?>: <?php echo e($check->version); ?></button>
								<?php endif; ?>
							</div>
						<?php else: ?>
							<div class="d-flex p-2">
								<a href="<?php echo e($item['pd_url_detail']); ?>" target="_blank" class="btn btn-sm btn-secondary mr-2"><i class="fas fa-eye"></i> <?php echo app('translator')->get("Detail"); ?></a>
								<a href="#" data-toggle="modal" data-productid="<?php echo e($item['pd_pid']); ?>" data-name="<?php echo e($item['pd_name']); ?>" data-pathmain="<?php echo e($item['pd_path_main_file']); ?>" 
								<?php if($item['envato_id']): ?>
									 data-verifytype="envato" 
								<?php else: ?>
									 data-verifytype="non_envato" 
								<?php endif; ?>
								data-productname="<?php echo e($item['pd_name']); ?>" 
								data-target="#installModule" class="btninstallModule btn btn-sm btn-primary"><i class="fab fa-instalod"></i> <?php echo app('translator')->get("Install now"); ?></a>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</div>
		<?php endif; ?>
	</div>
</div>
<div class="modal fade" id="installModule" tabindex="-1" role="dialog" aria-labelledby="installModuleLabel" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title"><i class="fas fa-file-archive"></i> <?php echo app('translator')->get('Install'); ?> <span id="installModuleTitle"></span> </h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
				<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<form  action="<?php echo e(route('settings.modulesmanager.install')); ?>" id="installModuleForm" method="post" enctype='multipart/form-data'>
				<?php echo csrf_field(); ?>
				<div class="modal-body">
					<input type="text" class="form-control" hidden="" name="verify_type" required="" id="verify_type">
					<input type="text" class="form-control" hidden="" name="path_main" required="" id="path_main">
					<input type="text" class="form-control" hidden="" name="product_id" required="" id="product_id">
					<input type="text" class="form-control" hidden="" name="product_name" required="" id="product_name">
					<div class="form-group">
						<label for="name" class="col-form-label"><?php echo app('translator')->get('Enter License'); ?>:</label>
						<input type="text" class="form-control" name="license" required="" id="license">
					</div>
					<div class="form-group">
						<label for="email" class="col-form-label"><?php echo app('translator')->get('Email purchase'); ?>:</label>
						<input type="email" class="form-control" name="email_username_purchase" required="" id="email_username_purchase">
					</div>
					<div class="form-group">
						<label for="name" class="col-form-label"><?php echo app('translator')->get('Notes'); ?>:</label>
						<div class="alert alert-primary">
							<ul class="mb-0">
								<li><?php echo app('translator')->get('Feature just can install modules or themes. Cannot use for reinstall main script'); ?></li>
								<li><?php echo app('translator')->get("Make sure your server doesn't block the permissions to install"); ?></li>
							</ul>
						</div>
					</div>
					
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
					<button type="submit" id="btnInstallModuleModal" class="btn btn-primary"><?php echo app('translator')->get('Install'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>


<?php $__env->startPush('scripts'); ?>
      <script src="<?php echo e(Module::asset('modulesmanager:js/modulemanager.js')); ?>" ></script>
 <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('core::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/project.maxxcapitals.com/Modules/ModulesManager/Providers/../Resources/views/index.blade.php ENDPATH**/ ?>