<!doctype html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="ltr">
  <head>
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta http-equiv="Content-Language" content="<?php echo e(app()->getLocale()); ?>" />
    <meta name="msapplication-TileColor" content="#2d89ef">
    <meta name="theme-color" content="#4188c9">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="HandheldFriendly" content="True">
    <meta name="MobileOptimized" content="320">
    <link rel="icon" href="<?php echo e(Storage::url(config('app.logo_favicon'))); ?>" type="image/png">
    <title><?php echo $__env->yieldContent('title', config('app.name')); ?></title>
    <meta name="description" content="<?php echo e(config('app.SITE_DESCRIPTION')); ?>">
    <meta name="keywords" content="<?php echo e(config('app.SITE_KEYWORDS')); ?>">
    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700,900" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(Module::asset('core:core/core.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Module::asset('core:app/css/customize.css')); ?>">
    <?php echo $__env->renderWhen(config('app.GOOGLE_ANALYTICS'), 'core::partials.google-analytics', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>
    
    <?php echo $__env->yieldPushContent('head'); ?>
    <script type="text/javascript">
      var BASE_URL = '<?php echo e(url('/')); ?>';
    </script>
  </head>
  <body id="page-top" class="sidebar-toggled">
    <!-- Page Wrapper -->
    <div id="wrapper">
      <!-- Sidebar -->
      <?php echo $__env->make('core::partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <!-- End of Sidebar -->
      <!-- Content Wrapper -->
      <div id="content-wrapper" class="d-flex flex-column">
        <!-- Main Content -->
        <div id="content">
          <!-- Topbar -->
          <?php echo $__env->make('core::partials.header-top', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
          <!-- End of Topbar -->
          <!-- Begin Page Content -->
          <div class="container-fluid">
            <?php if($errors->any()): ?>
            <div class="alert alert-danger">
              <ul class="list-unstyled mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li> <i class="fas fa-times text-danger mr-2"></i> <?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <?php endif; ?>
            <?php if(session('success')): ?>
                  <div class="alert alert-success">
                      <i class="fas fa-check-circle text-success mr-2"></i> <?php echo session('success'); ?>

                  </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <i class="fas fa-times text-danger mr-2"></i> <?php echo session('error'); ?>

                </div>
            <?php endif; ?>
            <!-- Page Heading -->
            <?php echo $__env->yieldContent('content'); ?>
            
          </div>
          <!-- /.container-fluid -->
        </div>
        <!-- End of Main Content -->
 
        <!-- Footer -->
        <footer class="sticky-footer">
          <div class="container my-auto">
            <div class="copyright text-center my-auto">
              <span><?php echo app('translator')->get('Copyright'); ?> © <?php echo e(now()->year); ?> <?php echo app('translator')->get('Desing by'); ?> <a href="<?php echo e(url('/')); ?>"><?php echo e(config('app.name')); ?></a></span>
            </div>
          </div>
        </footer>
        <!-- End of Footer -->
      </div>
      <!-- End of Content Wrapper -->
    </div>
        <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="createModalLabel" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo app('translator')->get('New Landing Page'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
              </div>
               <form id="" action="<?php echo e(route('landingpages.save')); ?>" method="post" enctype='multipart/form-data'>
                  <?php echo csrf_field(); ?>
              <div class="modal-body">
                  <div class="form-group">
                    <input type="number" class="form-control" name="template_id" hidden="" required="" id="template_id_builder">
                    <label for="name" class="col-form-label"><?php echo app('translator')->get('Name'); ?>:</label>
                    <input type="text" class="form-control" name="name" required="" id="page-name">
                  </div>
                
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                <button type="submit" class="btn btn-primary" id="saveandbuilder"><?php echo app('translator')->get('Save & Builder'); ?></button>
              </div>
              </form>
            </div>
          </div>
        </div>
    
    <a class="scroll-to-top rounded" href="#page-top">
      <i class="fas fa-angle-up"></i>
    </a>

   
    <script src="<?php echo e(Module::asset('core:core/core.js')); ?>" ></script>
    <script src="<?php echo e(Module::asset('core:vendor/tinymce/js/tinymce/tinymce.min.js')); ?>" ></script>
    <script src="<?php echo e(Module::asset('core:app/js/app.js')); ?>" ></script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
  </body>
</html><?php /**PATH /www/wwwroot/project.maxxcapitals.com/Modules/Core/Providers/../Resources/views/layouts/app.blade.php ENDPATH**/ ?>