<?php $__env->startSection('title', __('My Landing Pages')); ?>
<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
  <h1 class="h3 mb-0 text-gray-800"><?php echo app('translator')->get('My Landing Pages'); ?></h1>
  <form method="get" action="<?php echo e(route('landingpages.index')); ?>" class="my-3 my-lg-0 navbar-search">
    <div class="input-group">
      <input type="text" name="search" value="<?php echo e(Request::get('search')); ?>" class="form-control bg-light border-0 small" placeholder="<?php echo app('translator')->get('Search landing pages'); ?>" aria-label="Search" aria-describedby="basic-addon2">
      <div class="input-group-append">
        <button class="btn btn-primary" type="submit">
        <i class="fas fa-search fa-sm"></i>
        </button>
      </div>
    </div>
  </form>
</div>
<div class="row">
  <div class="col-sm-12">
    <?php if($data->count() > 0): ?>
    <div class="card">
      <div class="table-responsive min-h-200">
        <table class="table">
          <thead class="thead-dark">
            <tr>
              <th><?php echo app('translator')->get('Name'); ?></th>
              <th><?php echo app('translator')->get('Type'); ?></th>
              <th><?php echo app('translator')->get('Publish'); ?></th>
              <th><?php echo app('translator')->get('Domain'); ?></th>
              <th><?php echo app('translator')->get('Settings'); ?></th>
              <th><?php echo app('translator')->get('Action'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td>
                <a href="<?php echo e(route('landingpages.builder', $item->code)); ?>"><?php echo e($item->name); ?></a>
              </td>
              <td>
                <?php if(isset($item->template->name)): ?>
                  <?php echo e($item->template->name); ?>

                <?php else: ?>
                  <?php echo app('translator')->get('None'); ?>
                <?php endif; ?>
              </td>
              <td>
                <?php if($item->is_publish): ?>
                <span class="badge badge-success"><?php echo app('translator')->get('Published'); ?></span>
                <?php else: ?>
                <span class="badge badge-danger"><?php echo app('translator')->get('Not publish'); ?></span>
                <?php endif; ?>
                
              </td>
              <td>
                <?php if($item->domain_type == 0): ?>
                <a href="http://<?php echo e($item->sub_domain); ?>" target="_blank"><?php echo e($item->sub_domain); ?></a>
                <?php elseif($item->domain_type == 1): ?>
                <a href="http://<?php echo e($item->custom_domain); ?>"><?php echo e($item->custom_domain); ?></a>
                <?php endif; ?>
              </td>
              <td>
                <a href="<?php echo e(route('landingpages.setting', $item->code)); ?>" class="badge badge-primary"><i class="fas fa-cog"></i> <?php echo app('translator')->get('Setting'); ?></a>
              </td>
              <td>
                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-sm fa-fw"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" style="">
                      <a href="<?php echo e(route('landingpages.builder', $item->code)); ?>" class="dropdown-item"><?php echo app('translator')->get('Builder'); ?></a>
                      <form method="post" action="<?php echo e(route('landingpages.clone', $item)); ?>" >
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="dropdown-item">
                        <?php echo app('translator')->get('Clone'); ?>
                        </button>
                      </form>
                      <form method="post" action="<?php echo e(route('landingpages.delete', $item->code)); ?>" onsubmit="return confirm('<?php echo app('translator')->get('Confirm delete?'); ?>');">
                        <?php echo csrf_field(); ?>
                        <button class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
                      </form>
                    </div>
                </div>
                
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <?php endif; ?>
    <div class="mt-4">
      <?php echo e($data->appends( Request::all() )->links()); ?>

    </div>
  </div>
  
  
</div>
<div class="row">
  <div class="col-lg-12">
    <?php if($data->count() == 0): ?>
    <div class="text-center">
      <div class="error mx-auto mb-3"><i class="far fa-file-alt"></i></div>
      <p class="lead text-gray-800"><?php echo app('translator')->get('No Landing Page Found'); ?></p>
      <p class="text-gray-500"><?php echo app('translator')->get("You don't have any Landing Page"); ?>.</p>
      <a href="<?php echo e(route('alltemplates')); ?>" class="btn btn-primary">
        <span class="text"><?php echo app('translator')->get('New Landing Page'); ?></span>
      </a>
    </div>
    <?php endif; ?>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('core::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/project.maxxcapitals.com/Modules/LandingPage/Providers/../Resources/views/landingpages/index.blade.php ENDPATH**/ ?>