<?php $__env->startSection('title', __('Dashboard')); ?>
<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
  <h1 class="h3 mb-0 text-gray-600"><?php echo app('translator')->get('Dashboard'); ?></h1>
</div>
<div class="row">
  <div class="col-md-3 mb-3">
    <a href="<?php echo e(route('landingpages.index')); ?>" class="text-decoration-none">
    <div class="card shadow h-100">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="font-weight-bold text-gray-600 text-uppercase mb-1">
            <?php echo app('translator')->get('LandingPages'); ?></div>
            <div class="h5 mb-0 font-weight-bold text-gray-600"><?php echo e($landingpage_count); ?></div>
          </div>
          <div class="col-auto">
            <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
          </div>
        </div>
      </div>
    </div>
   </a>
  </div>
  <div class="col-md-3 mb-3">
    <a href="<?php echo e(route('leads.index')); ?>" class="text-decoration-none">
    <div class="card shadow h-100">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="font-weight-bold text-gray-600 text-uppercase mb-1"><?php echo app('translator')->get('Leads'); ?>
            </div>
            <div class="row no-gutters align-items-center">
              <div class="col-auto">
                <div class="h5 mb-0 mr-3 font-weight-bold text-gray-600"><?php echo e($formdata_count); ?></div>
              </div>
            </div>
          </div>
          <div class="col-auto">
            <i class="fas fa-user-friends fa-2x text-gray-300"></i>
          </div>
        </div>
      </div>
    </div>
    </a>
  </div>

  <div class="col-md-3 mb-3">
    <a href="<?php echo e(route('orders.index')); ?>" class="text-decoration-none">
    <div class="card shadow h-100">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="font-weight-bold text-gray-600 text-uppercase mb-1"><?php echo app('translator')->get('Total orders'); ?>
            </div>
            <div class="row no-gutters align-items-center">
              <div class="col-auto">
                <div class="h5 mb-0 mr-3 font-weight-bold text-gray-600"><?php echo e($total_order); ?></div>
              </div>
            </div>
          </div>
          <div class="col-auto">
            <i class="fas fa-cart-plus fa-2x text-gray-300"></i>
          </div>
        </div>
      </div>
    </div>
    </a>
  </div>

  <div class="col-md-3 mb-3">
    <a href="<?php echo e(route('orders.index')); ?>" class="text-decoration-none">
    <div class="card shadow h-100">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="font-weight-bold text-gray-600 text-uppercase mb-1"><?php echo app('translator')->get('Revenu'); ?>
            </div>
            <div class="row no-gutters align-items-center">
              <div class="col-auto">
                <div class="h5 mb-0 mr-3 font-weight-bold text-gray-600"><?php echo e($total_revenu); ?></div>
              </div>
            </div>
          </div>
          <div class="col-auto">
            <i class="fas fa-money-bill-alt fa-2x text-gray-300"></i>
          </div>
        </div>
      </div>
    </div>
    </a>
  </div>
</div>
<div class="row">
  <div class="col-lg-6 mb-4">
    <div class="card shadow mb-4">
      <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-gray-600"><?php echo app('translator')->get('Browser Leads'); ?></h6>
      </div>
      <div class="card-body">
        <?php
        $total = $stats_browser->sum('total');
        ?>
        <?php $__currentLoopData = $stats_browser; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
        $percent = get_percentage($total,$item->total);
        ?>
        <h6><?php echo e($item->browser); ?> <small>(<?php echo e($item->total); ?>)</small><span class="float-right"><?php echo e($percent); ?>%</span></h6>
        <div class="progress mb-4">
          <div class="progress-bar bg-<?php echo e(random_color()); ?>" role="progressbar" style="width: <?php echo e($percent); ?>%" aria-valuenow="<?php echo e($percent); ?>" aria-valuemin="0" aria-valuemax="100"></div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </div>
    <div class="card shadow mb-4">
      <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-gray-600"><?php echo app('translator')->get('OS Leads'); ?></h6>
      </div>
      <div class="card-body">
        <?php
        $total = $stats_os->sum('total');
        ?>
        <?php $__currentLoopData = $stats_os; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
        $percent = get_percentage($total,$item->total);
        ?>
        <h6><?php echo e($item->os); ?> <small>(<?php echo e($item->total); ?>)</small><span class="float-right"><?php echo e($percent); ?>%</span></h6>
        <div class="progress mb-4">
          <div class="progress-bar bg-<?php echo e(random_color()); ?>" role="progressbar" style="width: <?php echo e($percent); ?>%" aria-valuenow="<?php echo e($percent); ?>" aria-valuemin="0" aria-valuemax="100"></div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
      
    </div>
  </div>
  <div class="col-lg-6 mb-4">
    <div class="card shadow mb-4">
      <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-gray-600"><?php echo app('translator')->get('Device Leads'); ?></h6>
      </div>
      <!-- Card Body -->
      <div class="card-body">
        <div class="chart-pie pt-4 pb-2">
          <canvas id="devicePieChart"></canvas>
        </div>
      </div>
    </div>
  </div>
  
</div>
<div class="row">
  <div class="col-lg-6 mb-4">
    
  </div>
  
</div>
<?php if($data_days_visible): ?>
    <div class="row">
        <div class="col-md-12"> 
            <canvas id="data_days_chart"></canvas>
        </div>
        <div class="col-md-12 mt-2">
            <p class="text-center"><span class=""><?php echo app('translator')->get('Data collectors in the last 7 days'); ?></span><p>
        </div>
    </div>
<?php endif; ?>

<?php if(count($stats_device) > 0): ?>
  <?php
    $arr_total_device = array();
    $arr_str_device = array();
    $arr_colors = get_color_chart_count(count($stats_device));
  ?>
  <?php $__currentLoopData = $stats_device; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
      $arr_total_device[] = $item->total;
      $arr_str_device[] = $item->device;
    ?>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

  <?php $__env->startPush('scripts'); ?>
      <script type="text/javascript">
        var arr_total_device = <?php echo json_encode($arr_total_device, 15, 512) ?>;
        var arr_str_device = <?php echo json_encode($arr_str_device, 15, 512) ?>;
        var arr_colors = <?php echo json_encode($arr_colors, 15, 512) ?>;
      </script>
      <script>
          const DASHBOARD_DATA_DAYS_VISIBLE = <?php echo $data_days_visible ? 'true' : 'false'; ?>;
          const DASHBOARD_DATA_DAYS_CHART_LABELS = <?php echo $data_days_chart['labels']; ?>;
          const DASHBOARD_DATA_DAYS_CHART_COLLECTORS = <?php echo $data_days_chart['collectors'] ?? '[]'; ?>;
          const LANGS = {
              "data_collectors": "<?php echo app('translator')->get('Data Collectors'); ?>",
          };
      </script>

      <script src="<?php echo e(Module::asset('landingpage:js/dashboard.js')); ?>" ></script>
  <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('core::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/project.maxxcapitals.com/Modules/LandingPage/Providers/../Resources/views/dashboard.blade.php ENDPATH**/ ?>