<?php $__env->startSection('title', __('Leads')); ?>
<?php $__env->startSection('content'); ?>

<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800"><?php echo app('translator')->get('Leads'); ?></h1>
    <?php 
      $export_params = [];
      if(!empty($request_landingpage_code)) {
          $export_params["landingpage_code"] = $request_landingpage_code;
      }
      if(!empty($request_popup_code)) {
          $export_params["popup_code"] = $request_popup_code;
      }
    ?>
    <a href="
        <?php if(count($export_params) > 0): ?> 
            <?php echo e(route('leads.exportcsv', $export_params)); ?> 
        <?php else: ?>
            <?php echo e(route('leads.exportcsv')); ?> 
        <?php endif; ?>
    " class="btn btn-primary"><?php echo app('translator')->get('Export all'); ?></a>
</div>
<div class="card">
  <div class="card-body">
      <div class="table-responsive">
          <table class="table" id="data-table">
              <thead>
                  <tr>
                      <th><?php echo app('translator')->get('Lead Info'); ?></th>
                      <th><?php echo app('translator')->get('From'); ?></th>
                      <th><?php echo app('translator')->get('Browser'); ?></th>
                      <th><?php echo app('translator')->get('OS'); ?></th>
                      <th><?php echo app('translator')->get('Device'); ?></th>
                      <th><?php echo app('translator')->get('Dates'); ?></th>
                      <th><?php echo app('translator')->get('Action'); ?></th>
                  </tr>
              </thead>
          </table>
      </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    const FORMS_TOKEN = '<?php echo e(csrf_token()); ?>';
    const FORMS_DATA_AJAX_URL = "<?php echo e(route('leads.ajax')); ?>";
    const FORMS_DESTROY_URL = "<?php echo e(route('leads.destroy')); ?>";
    <?php 
      $tmp_landingpages = '';
      foreach($landingpages as $landingpage) {
        $tmp_landingpages .= '<option value="' . $landingpage->id . '">' . $landingpage->name . '</option>';
      }
    ?>
    
    var HTML_TABLE_FILTER = ``;

    <?php if(Module::find('Popup')): ?>
      <?php 
        $tmp_popups = '';
        foreach($popups as $popup) {
          $tmp_popups .= '<option value="' . $popup->id . '">' . $popup->name . '</option>';
        }
      ?>
      HTML_TABLE_FILTER += `<label style="margin-left: 8px;">`;
      HTML_TABLE_FILTER += `<select name="popup_id" class="form-control form-control-sm">`;
      HTML_TABLE_FILTER += `<option value="">All popups</option>`;
      HTML_TABLE_FILTER += '<?php echo $tmp_popups; ?>';
      HTML_TABLE_FILTER += `</select>`;
      HTML_TABLE_FILTER += `</label>`;
    <?php endif; ?>

    HTML_TABLE_FILTER += `<label style="margin-left: 8px;">`;
    HTML_TABLE_FILTER += `<select name="landingpage_id" style="max-width:200px;" class="form-control form-control-sm">`;
    HTML_TABLE_FILTER += `<option value="">All landing pages</option>`;
    HTML_TABLE_FILTER +=  '<?php echo $tmp_landingpages; ?>';
    HTML_TABLE_FILTER += `</select>`;
    HTML_TABLE_FILTER += `</label>`;

    const searchPlaceholder = "<?php echo app('translator')->get('Search lead info'); ?>";
    const FORMS_CONFIRM_DELETE_MESSAGE = "<?php echo app('translator')->get('Confirm Delete?'); ?>";

</script>
<script src="<?php echo e(Module::asset('forms:js/data.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('core::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/project.maxxcapitals.com/Modules/Forms/Providers/../Resources/views/leads/index.blade.php ENDPATH**/ ?>